//Falcon-180B DATASET v1.0 Category: Modern Encryption ; Style: introspective
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define SIZE 100
#define KEY_SIZE 16

void generate_key(char key[KEY_SIZE]) {
    int i;
    for (i = 0; i < KEY_SIZE; i++) {
        key[i] = rand() % 26 + 'a';
    }
}

void generate_message(char message[SIZE]) {
    int i;
    for (i = 0; i < SIZE; i++) {
        message[i] = rand() % 26 + 'a';
    }
}

void encrypt(char message[SIZE], char key[KEY_SIZE]) {
    int i;
    for (i = 0; i < SIZE; i++) {
        message[i] = message[i] + key[i % KEY_SIZE];
        if (message[i] > 'z') {
            message[i] = message[i] - 26;
        }
    }
}

void decrypt(char message[SIZE], char key[KEY_SIZE]) {
    int i;
    for (i = 0; i < SIZE; i++) {
        message[i] = message[i] - key[i % KEY_SIZE];
        if (message[i] < 'a') {
            message[i] = message[i] + 26;
        }
    }
}

int main() {
    char message[SIZE];
    char key[KEY_SIZE];
    srand(time(NULL));
    generate_message(message);
    generate_key(key);
    printf("Original message: %s\n", message);
    encrypt(message, key);
    printf("Encrypted message: %s\n", message);
    decrypt(message, key);
    printf("Decrypted message: %s\n", message);
    return 0;
}