//Falcon-180B DATASET v1.0 Category: Haunted House Simulator ; Style: decentralized
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define NUM_ROOMS 5
#define NUM_ITEMS 10
#define NUM_ENEMIES 3
#define NUM_PLAYERS 1

enum RoomType {
    EMPTY,
    ITEM,
    ENEMY
};

struct Room {
    enum RoomType type;
    int item;
    int enemy;
};

void generate_room(struct Room *room) {
    room->type = rand() % 3;
    if (room->type == ITEM) {
        room->item = rand() % NUM_ITEMS;
    } else if (room->type == ENEMY) {
        room->enemy = rand() % NUM_ENEMIES;
    }
}

void generate_house(struct Room house[NUM_ROOMS]) {
    for (int i = 0; i < NUM_ROOMS; i++) {
        generate_room(&house[i]);
    }
}

void print_room(struct Room room) {
    if (room.type == EMPTY) {
        printf("Empty room\n");
    } else if (room.type == ITEM) {
        printf("You found item %d!\n", room.item);
    } else if (room.type == ENEMY) {
        printf("You were attacked by enemy %d!\n", room.enemy);
    }
}

int main() {
    srand(time(NULL));
    struct Room house[NUM_ROOMS];
    generate_house(house);

    int player_pos = 0;
    while (player_pos < NUM_ROOMS) {
        printf("You are in room %d\n", player_pos + 1);
        print_room(house[player_pos]);
        player_pos++;
    }

    return 0;
}