//Falcon2-11B DATASET v1.0 Category: Matrix operations ; Style: single-threaded
#include <stdio.h>
#include <stdlib.h>

// function to add two matrices
void addMatrices(int A[][3], int B[][3], int C[][3], int m, int n) {
    for (int i = 0; i < m; i++) {
        for (int j = 0; j < n; j++) {
            C[i][j] = A[i][j] + B[i][j];
        }
    }
}

// function to subtract two matrices
void subtractMatrices(int A[][3], int B[][3], int C[][3], int m, int n) {
    for (int i = 0; i < m; i++) {
        for (int j = 0; j < n; j++) {
            C[i][j] = A[i][j] - B[i][j];
        }
    }
}

// function to multiply two matrices
void multiplyMatrices(int A[][3], int B[][3], int C[][3], int m, int n) {
    for (int i = 0; i < m; i++) {
        for (int j = 0; j < n; j++) {
            C[i][j] = 0;
            for (int k = 0; k < n; k++) {
                C[i][j] += A[i][k] * B[k][j];
            }
        }
    }
}

// function to transpose a matrix
void transposeMatrix(int A[][3], int B[][3], int m, int n) {
    for (int i = 0; i < m; i++) {
        for (int j = 0; j < n; j++) {
            B[j][i] = A[i][j];
        }
    }
}

// function to print a matrix
void printMatrix(int A[][3], int m, int n) {
    for (int i = 0; i < m; i++) {
        for (int j = 0; j < n; j++) {
            printf("%d ", A[i][j]);
        }
        printf("\n");
    }
}

int main() {
    int A[3][3] = {{1, 2, 3}, {4, 5, 6}, {7, 8, 9}};
    int B[3][3] = {{9, 8, 7}, {6, 5, 4}, {3, 2, 1}};
    int C[3][3] = {{0, 0, 0}, {0, 0, 0}, {0, 0, 0}};
    int m = 3;
    int n = 3;

    addMatrices(A, B, C, m, n);
    printf("Addition of matrices A and B:\n");
    printMatrix(C, m, n);

    subtractMatrices(A, B, C, m, n);
    printf("Subtraction of matrices A and B:\n");
    printMatrix(C, m, n);

    multiplyMatrices(A, B, C, m, n);
    printf("Multiplication of matrices A and B:\n");
    printMatrix(C, m, n);

    transposeMatrix(A, C, m, n);
    printf("Transpose of matrix A:\n");
    printMatrix(C, m, n);

    return 0;
}