//Falcon-180B DATASET v1.0 Category: Alien Invasion Probability Calculator ; Style: recursive
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_TRIES 1000
#define MAX_FACTOR 100
#define MIN_POPULATION 100
#define MAX_POPULATION 1000000
#define MIN_TECHNOLOGY 1
#define MAX_TECHNOLOGY 100
#define MIN_DISTANCE 1
#define MAX_DISTANCE 1000000

int randInt(int min, int max);
int randFactor();
int randPopulation();
int randTechnology();
int randDistance();
int alienInvasionProbability(int population, int technology, int distance);

int main() {
    srand(time(NULL));
    int tries = 0;
    int totalProbability = 0;

    while (tries < MAX_TRIES && totalProbability == 0) {
        int population = randPopulation();
        int technology = randTechnology();
        int distance = randDistance();
        totalProbability += alienInvasionProbability(population, technology, distance);
        tries++;
    }

    printf("Alien Invasion Probability: %d%%\n", totalProbability);
    return 0;
}

int randInt(int min, int max) {
    return rand() % (max - min + 1) + min;
}

int randFactor() {
    return randInt(1, MAX_FACTOR);
}

int randPopulation() {
    return randInt(MIN_POPULATION, MAX_POPULATION);
}

int randTechnology() {
    return randInt(MIN_TECHNOLOGY, MAX_TECHNOLOGY);
}

int randDistance() {
    return randInt(MIN_DISTANCE, MAX_DISTANCE);
}

int alienInvasionProbability(int population, int technology, int distance) {
    int probability = 0;

    if (population > 0 && technology > 0 && distance > 0) {
        probability += randInt(1, 100);
    } else {
        probability = 0;
    }

    return probability;
}