//GEMINI-pro DATASET v1.0 Category: Geometric algorithms ; Style: ultraprecise
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define EPSILON 1e-9

typedef struct {
  double x, y;
} point;

typedef struct {
  point p1, p2;
} segment;

typedef struct {
  point center;
  double radius;
} circle;

int equal(double a, double b) {
  return fabs(a - b) < EPSILON;
}

int point_on_segment(point p, segment s) {
  return equal(p.x, s.p1.x) && equal(p.y, s.p1.y) ||
         equal(p.x, s.p2.x) && equal(p.y, s.p2.y);
}

int segment_intersect(segment s1, segment s2) {
  double x1 = s1.p1.x, y1 = s1.p1.y, x2 = s1.p2.x, y2 = s1.p2.y;
  double x3 = s2.p1.x, y3 = s2.p1.y, x4 = s2.p2.x, y4 = s2.p2.y;
  double dx1 = x2 - x1, dy1 = y2 - y1;
  double dx2 = x4 - x3, dy2 = y4 - y3;
  double denominator = dx1 * dy2 - dx2 * dy1;
  if (equal(denominator, 0)) {
    return point_on_segment(s1.p1, s2) || point_on_segment(s1.p2, s2) ||
           point_on_segment(s2.p1, s1) || point_on_segment(s2.p2, s1);
  }
  double ua = (dx2 * (y1 - y3) - dy2 * (x1 - x3)) / denominator;
  double ub = (dx1 * (y3 - y1) - dy1 * (x3 - x1)) / denominator;
  return ua >= 0 && ua <= 1 && ub >= 0 && ub <= 1;
}

int point_in_circle(point p, circle c) {
  return sqrt((p.x - c.center.x) * (p.x - c.center.x) +
              (p.y - c.center.y) * (p.y - c.center.y)) < c.radius;
}

int segment_tangent_to_circle(segment s, circle c) {
  double x1 = s.p1.x, y1 = s.p1.y, x2 = s.p2.x, y2 = s.p2.y;
  double dx = x2 - x1, dy = y2 - y1;
  double d = sqrt(dx * dx + dy * dy);
  double cx = c.center.x, cy = c.center.y, r = c.radius;
  double h = ((x1 - cx) * dx + (y1 - cy) * dy) / d;
  double hx = cx + h * dx / d, hy = cy + h * dy / d;
  double dist = sqrt((hx - cx) * (hx - cx) + (hy - cy) * (hy - cy));
  return equal(dist, r);
}

int main() {
  point p1 = {1, 2}, p2 = {3, 4}, q1 = {2, 3}, q2 = {4, 5};
  segment s1 = {p1, p2}, s2 = {q1, q2};
  circle c = {{0, 0}, 2};
  printf("Segment %d intersect? %d\n", 1, segment_intersect(s1, s2));
  printf("Segment %d tangent to circle? %d\n", 2, segment_tangent_to_circle(s1, c));
  printf("Point %d in circle? %d\n", 3, point_in_circle(p1, c));
  printf("Point %d in circle? %d\n", 4, point_in_circle(p2, c));
  return 0;
}