//Falcon-180B DATASET v1.0 Category: Network Packet Monitoring ; Style: shocked
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <pcap.h>
#include <pthread.h>

#define MAX_DATA_LEN 65535
#define SNAPLEN 65535
#define TRUE 1
#define FALSE 0

typedef struct packet_data {
    u_char *data;
    int len;
} packet_data_t;

void packet_handler(u_char *args, const struct pcap_pkthdr *header, const u_char *packet) {
    packet_data_t *data = (packet_data_t *) args;
    data->data = (u_char *) malloc(header->len);
    if (data->data == NULL) {
        fprintf(stderr, "Memory allocation failed\n");
        exit(1);
    }
    memcpy(data->data, packet, header->len);
    data->len = header->len;
}

void *monitor_packets(void *arg) {
    pcap_t *handle;
    char errbuf[PCAP_ERRBUF_SIZE];
    const u_char *packet;
    packet_data_t data;

    handle = pcap_open_live(arg, SNAPLEN, TRUE, 0, errbuf);
    if (handle == NULL) {
        fprintf(stderr, "Error opening network device: %s\n", errbuf);
        return NULL;
    }

    pcap_loop(handle, -1, packet_handler, &data);

    pcap_close(handle);

    return NULL;
}

int main() {
    pthread_t thread_id;
    char *device_name = "eth0"; // replace with your network device name

    pthread_create(&thread_id, NULL, monitor_packets, device_name);

    printf("Packet monitoring started on device %s\n", device_name);

    pthread_join(thread_id, NULL);

    return 0;
}