//GPT-4o-mini DATASET v1.0 Category: Greedy Algorithms ; Style: Romeo and Juliet
#include <stdio.h>
#include <stdlib.h>

typedef struct {
    int distance; // Distance of the rose
    int beauty;   // Beauty score of the rose
} Rose;

// Comparison function for qsort
int compareRoses(const void *a, const void *b) {
    Rose *roseA = (Rose *)a;
    Rose *roseB = (Rose *)b;
    return roseB->beauty - roseA->beauty; // Sort by beauty descending
}

// Function to collect the most beautiful roses Romeo can carry
void collectRoses(Rose *roses, int roseCount, int maxDistance) {
    // Sort roses by beauty in descending order
    qsort(roses, roseCount, sizeof(Rose), compareRoses);

    int totalDistance = 0;
    int totalBeauty = 0;

    printf("Romeo's journey to collect roses for Juliet:\n");
    
    for (int i = 0; i < roseCount; i++) {
        if (totalDistance + roses[i].distance <= maxDistance) {
            totalDistance += roses[i].distance;
            totalBeauty += roses[i].beauty;
            printf("Collected rose at distance %d with beauty %d.\n", roses[i].distance, roses[i].beauty);
        } else {
            printf("Cannot collect rose at distance %d, too far!\n", roses[i].distance);
        }
    }

    printf("\nTotal distance traveled: %d\n", totalDistance);
    printf("Total beauty of collected roses: %d\n", totalBeauty);
}

int main() {
    // A tale of roses for Juliet
    int maxDistance = 15; // Maximum distance Romeo can travel
    Rose roses[] = {
        {3, 10}, // Distance: 3, Beauty: 10
        {5, 6},  // Distance: 5, Beauty: 6
        {2, 8},  // Distance: 2, Beauty: 8
        {7, 5},  // Distance: 7, Beauty: 5
        {4, 7},  // Distance: 4, Beauty: 7
        {1, 9}   // Distance: 1, Beauty: 9
    };

    int roseCount = sizeof(roses) / sizeof(roses[0]);

    collectRoses(roses, roseCount, maxDistance);
    
    return 0;
}