//Falcon-180B DATASET v1.0 Category: Database Indexing System ; Style: futuristic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_NAME_LEN 100
#define MAX_KEY_LEN 100
#define MAX_VALUE_LEN 1000
#define MAX_INDEXES 100
#define MAX_INDEX_KEY_LEN 100

typedef struct {
    char name[MAX_NAME_LEN];
    char key[MAX_KEY_LEN];
    char value[MAX_VALUE_LEN];
} Record;

typedef struct {
    char key[MAX_INDEX_KEY_LEN];
    int index;
} Index;

Record records[MAX_INDEXES];
Index indexes[MAX_INDEXES];
int numRecords = 0;
int numIndexes = 0;

void addRecord(char* name, char* key, char* value) {
    strcpy(records[numRecords].name, name);
    strcpy(records[numRecords].key, key);
    strcpy(records[numRecords].value, value);
    numRecords++;
}

void addIndex(char* key) {
    strcpy(indexes[numIndexes].key, key);
    indexes[numIndexes].index = numRecords - 1;
    numIndexes++;
}

void search(char* key) {
    int i;
    for (i = 0; i < numIndexes; i++) {
        if (strcmp(key, indexes[i].key) == 0) {
            printf("Found record with key: %s\n", indexes[i].key);
            printf("Name: %s\n", records[indexes[i].index].name);
            printf("Value: %s\n", records[indexes[i].index].value);
            return;
        }
    }
    printf("Record not found.\n");
}

int main() {
    addRecord("John Doe", "123", "456");
    addRecord("Jane Doe", "789", "012");
    addIndex("123");
    addIndex("789");

    search("123");

    return 0;
}