//LLAMA2-13B DATASET v1.0 Category: Matrix operations ; Style: minimalist
#include <stdio.h>
#include <stdlib.h>

// Matrix operations

// Multiply two matrices
void matMul(float (*A)[3], float (*B)[3], float (*C)[3]) {
  for (int i = 0; i < 3; i++) {
    for (int j = 0; j < 3; j++) {
      C[i][j] = A[i][0] * B[0][j] + A[i][1] * B[1][j] + A[i][2] * B[2][j];
    }
  }
}

// Add two matrices
void matAdd(float (*A)[3], float (*B)[3], float (*C)[3]) {
  for (int i = 0; i < 3; i++) {
    for (int j = 0; j < 3; j++) {
      C[i][j] = A[i][j] + B[i][j];
    }
  }
}

// Transpose a matrix
void matTranspose(float (*A)[3], float (*B)[3]) {
  for (int i = 0; i < 3; i++) {
    for (int j = 0; j < 3; j++) {
      B[i][j] = A[j][i];
    }
  }
}

int main() {
  float A[3][3] = {{1, 2, 3}, {4, 5, 6}, {7, 8, 9}};
  float B[3][3] = {{10, 20, 30}, {40, 50, 60}, {70, 80, 90}};
  float C[3][3];

  // Multiply A and B
  matMul(A, B, C);

  // Print the result
  for (int i = 0; i < 3; i++) {
    for (int j = 0; j < 3; j++) {
      printf("%.2f ", C[i][j]);
    }
    printf("\n");
  }

  // Add A and B
  matAdd(A, B, C);

  // Transpose A
  matTranspose(A, B);

  return 0;
}