//GPT-4o-mini DATASET v1.0 Category: Network Packet Monitoring ; Style: creative
#include <stdio.h>
#include <pcap.h>
#include <arpa/inet.h>
#include <netinet/ip.h>
#include <netinet/udp.h>
#include <netinet/tcp.h>
#include <netinet/ether.h>
#include <string.h>

void packet_handler(u_char *args, const struct pcap_pkthdr *header, const u_char *packet) {
    // Ethernet header
    struct ether_header *eth_header = (struct ether_header *) packet;
    printf("Ethernet Frame: src: %s, dst: %s, type: 0x%04x\n",
           ether_ntoa((struct ether_addr *)&eth_header->ether_shost),
           ether_ntoa((struct ether_addr *)&eth_header->ether_dhost),
           ntohs(eth_header->ether_type));

    // Check if it is IPv4
    if (ntohs(eth_header->ether_type) == ETHERTYPE_IP) {
        struct ip *ip_header = (struct ip *)(packet + sizeof(struct ether_header));
        printf("   IPv4 Packet from %s to %s, Protocol: %d\n",
               inet_ntoa(ip_header->ip_src),
               inet_ntoa(ip_header->ip_dst),
               ip_header->ip_p);

        // Check for TCP
        if (ip_header->ip_p == IPPROTO_TCP) {
            struct tcphdr *tcp_header = (struct tcphdr *)(packet + sizeof(struct ether_header) + sizeof(struct ip));
            printf("      TCP: src port: %d, dst port: %d\n",
                   ntohs(tcp_header->source),
                   ntohs(tcp_header->dest));
        }

        // Check for UDP
        if (ip_header->ip_p == IPPROTO_UDP) {
            struct udphdr *udp_header = (struct udphdr *)(packet + sizeof(struct ether_header) + sizeof(struct ip));
            printf("      UDP: src port: %d, dst port: %d\n",
                   ntohs(udp_header->source),
                   ntohs(udp_header->dest));
        }
    }

    printf("Packet captured with length: %d\n\n", header->len);
}

int main() {
    char *dev;
    char errbuf[PCAP_ERRBUF_SIZE];
    
    // Finding a default device to capture
    dev = pcap_lookupdev(errbuf);
    if (dev == NULL) {
        fprintf(stderr, "Couldn't find default device: %s\n", errbuf);
        return 1;
    }
    printf("Using device: %s\n", dev);

    // Open device for listening
    pcap_t *handle = pcap_open_live(dev, BUFSIZ, 1, 1000, errbuf);
    if (handle == NULL) {
        fprintf(stderr, "Couldn't open device %s: %s\n", dev, errbuf);
        return 2;
    }

    // Start packet capture loop
    printf("Starting packet capture...\n");
    pcap_loop(handle, 10, packet_handler, NULL);

    // Cleanup
    pcap_close(handle);
    printf("Capture finished.\n");

    return 0;
}