//GEMINI-pro DATASET v1.0 Category: Wireless Network Scanner ; Style: introspective
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <net/if.h>
#include <sys/ioctl.h>
#include <linux/wireless.h>

int main() {
    int sock, i, j;
    struct ifreq ifr;
    struct iwreq iwr;
    char buf[1024];

    // Open a socket
    sock = socket(AF_INET, SOCK_DGRAM, 0);
    if (sock < 0) {
        perror("socket");
        return EXIT_FAILURE;
    }

    // Get a list of interfaces
    memset(&ifr, 0, sizeof(ifr));
    strncpy(ifr.ifr_name, "wlan0", IFNAMSIZ);
    if (ioctl(sock, SIOCGIFFLAGS, &ifr) < 0) {
        perror("ioctl");
        return EXIT_FAILURE;
    }

    // Check if the interface is up
    if (!(ifr.ifr_flags & IFF_UP)) {
        printf("Interface %s is down\n", ifr.ifr_name);
        return EXIT_FAILURE;
    }

    // Get a list of access points
    memset(&iwr, 0, sizeof(iwr));
    strncpy(iwr.ifr_name, "wlan0", IFNAMSIZ);
    iwr.u.data.pointer = buf;
    iwr.u.data.length = sizeof(buf);
    if (ioctl(sock, SIOCGIWSCAN, &iwr) < 0) {
        perror("ioctl");
        return EXIT_FAILURE;
    }

    // Parse the list of access points
    j = 0;
    for (i = 0; i < iwr.u.data.length; i++) {
        if (buf[i] == '\0') {
            printf("Access point %d:\n", ++j);
            printf("  MAC: %s\n", buf + i - 17);
            printf("  SSID: %s\n", buf + i - 32);
            printf("  Signal: %d dBm\n", *(buf + i - 2) + 100);
        }
    }

    // Close the socket
    close(sock);

    return EXIT_SUCCESS;
}