//Code Llama-13B DATASET v1.0 Category: Linked list operations ; Style: Linus Torvalds
/*
 * A simple Linked List example program in Linus Torvalds style
 *
 * Author: [Your Name]
 */

#include <stdio.h>
#include <stdlib.h>

/* Linked List Node */
typedef struct node {
    int data;
    struct node *next;
} node_t;

/* Linked List */
typedef struct {
    node_t *head;
    node_t *tail;
} list_t;

/* Creates a new node */
node_t *create_node(int data)
{
    node_t *node = malloc(sizeof(node_t));
    if (!node) {
        printf("Failed to allocate memory for node\n");
        return NULL;
    }

    node->data = data;
    node->next = NULL;

    return node;
}

/* Adds a node to the end of the list */
void add_node(list_t *list, int data)
{
    node_t *node = create_node(data);
    if (!node) {
        printf("Failed to create node\n");
        return;
    }

    if (list->head == NULL) {
        list->head = node;
        list->tail = node;
    } else {
        list->tail->next = node;
        list->tail = node;
    }
}

/* Removes the first node with the given data from the list */
void remove_node(list_t *list, int data)
{
    node_t *node = list->head;
    node_t *prev = NULL;

    while (node != NULL) {
        if (node->data == data) {
            if (prev == NULL) {
                list->head = node->next;
            } else {
                prev->next = node->next;
            }

            free(node);
            return;
        }

        prev = node;
        node = node->next;
    }
}

/* Prints the list */
void print_list(list_t *list)
{
    node_t *node = list->head;

    while (node != NULL) {
        printf("%d ", node->data);
        node = node->next;
    }

    printf("\n");
}

/* Frees the list */
void free_list(list_t *list)
{
    node_t *node = list->head;
    node_t *next = NULL;

    while (node != NULL) {
        next = node->next;
        free(node);
        node = next;
    }

    list->head = NULL;
    list->tail = NULL;
}

int main()
{
    list_t list;

    /* Initialize the list */
    list.head = NULL;
    list.tail = NULL;

    /* Add nodes to the list */
    add_node(&list, 1);
    add_node(&list, 2);
    add_node(&list, 3);
    add_node(&list, 4);

    /* Print the list */
    print_list(&list);

    /* Remove a node */
    remove_node(&list, 3);

    /* Print the list again */
    print_list(&list);

    /* Free the list */
    free_list(&list);

    return 0;
}