//LLAMA2-13B DATASET v1.0 Category: Sorting ; Style: relaxed
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

// Define a struct to hold our sortable items
struct sortable {
    int id;
    char name[20];
};

// Function to swap two sortable items
void swap_sortables(struct sortable *a, struct sortable *b) {
    struct sortable temp = *a;
    *a = *b;
    *b = temp;
}

// Function to sort the list of sortable items
void sort_list(struct sortable *list, int num_items) {
    int i, j, k;
    for (i = 0; i < num_items - 1; i++) {
        for (j = i + 1; j < num_items; j++) {
            if (strcmp(list[i].name, list[j].name) > 0) {
                swap_sortables(&list[i], &list[j]);
            }
        }
    }
}

// Function to print the sorted list
void print_list(struct sortable *list, int num_items) {
    int i;
    for (i = 0; i < num_items; i++) {
        printf("%d - %s\n", list[i].id, list[i].name);
    }
}

int main() {
    // Generate some random data
    srand(time(NULL));
    struct sortable list[10] = {
        {1, "Alice"},
        {2, "Bob"},
        {3, "Charlie"},
        {4, "David"},
        {5, "Eve"},
        {6, "Frank"},
        {7, "Grace"},
        {8, "Helen"},
        {9, "Ivan"}
    };
    int num_items = sizeof(list) / sizeof(list[0]);

    // Sort the list
    sort_list(list, num_items);

    // Print the sorted list
    print_list(list, num_items);

    return 0;
}