//GPT-4o-mini DATASET v1.0 Category: Secure Password Generator ; Style: enthusiastic
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>

#define PASSWORD_LENGTH 12    // Length of the generated password
#define NUM_SPECIALS 4        // Number of special characters to include
#define NUM_DIGITS 3          // Number of digits to include
#define NUM_UPPERCASE 3       // Number of uppercase letters to include
#define NUM_LOWERCASE 2       // Number of lowercase letters to include

void generatePassword(char *password);
void shuffle(char *password, int length);
void printPassword(char *password);

int main() {
    char password[PASSWORD_LENGTH + 1]; // Extra space for the null terminator
    srand(time(NULL)); // Seed the random number generator

    printf("Welcome to the Secure Password Generator!\n");
    printf("Generating a strong password...\n");

    generatePassword(password);
    printPassword(password);

    return 0;
}

void generatePassword(char *password) {
    int index = 0;

    // Arrays of character types
    const char *specialCharacters = "!@#$%^&*";
    const char *digits = "0123456789";
    const char *uppercase = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    const char *lowercase = "abcdefghijklmnopqrstuvwxyz";

    // Fill password with required types
    for (int i = 0; i < NUM_SPECIALS; i++, index++) {
        password[index] = specialCharacters[rand() % strlen(specialCharacters)];
    }
    for (int i = 0; i < NUM_DIGITS; i++, index++) {
        password[index] = digits[rand() % strlen(digits)];
    }
    for (int i = 0; i < NUM_UPPERCASE; i++, index++) {
        password[index] = uppercase[rand() % strlen(uppercase)];
    }
    for (int i = 0; i < NUM_LOWERCASE; i++, index++) {
        password[index] = lowercase[rand() % strlen(lowercase)];
    }

    // Fill the rest of the password with random characters (upper case, lower case, digits, and specials)
    const char *allCharacters = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!@#$%^&*";
    for (; index < PASSWORD_LENGTH; index++) {
        password[index] = allCharacters[rand() % strlen(allCharacters)];
    }

    password[PASSWORD_LENGTH] = '\0'; // Null terminate the password string
    shuffle(password, PASSWORD_LENGTH); // Shuffle the password characters
}

void shuffle(char *password, int length) {
    // Shuffle the password to ensure randomness
    for (int i = length - 1; i > 0; i--) {
        int j = rand() % (i + 1);
        // Swap characters at i and j
        char temp = password[i];
        password[i] = password[j];
        password[j] = temp;
    }
}

void printPassword(char *password) {
    printf("Your generated secure password is: %s\n", password);
}