//MISTRAL-7B DATASET v1.0 Category: Building a SMTP Client ; Style: decentralized
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <curl/curl.h>

#define SERVER_PORT 25
#define BUFFER_SIZE 2048
#define HELO_STR "HELO localhost\r\n"
#define MAIL_FROM_STR "MAIL FROM:<test@example.com>\r\n"
#define RCPT_TO_STR "RCPT TO:<test@example.com>\r\n"
#define DATA_STR "DATA\r\n"
#define END_DATA_STR "\r\n.\r\n"
#define QUIT_STR "QUIT\r\n"

static size_t WriteCallback(void *contents, size_t size, size_t nmemb, void *userp) {
    size_t realsize = size * nmemb;
    fwrite(contents, size, realsize, stdout);
    return realsize;
}

int main(int argc, char *argv[]) {
    CURL *curl;
    CURLcode res;
    struct sockaddr_in server_address;
    int sockfd;

    curl = curl_easy_init();
    if(curl) {
        memset(&server_address, 0, sizeof(server_address));
        server_address.sin_family = AF_INET;
        server_address.sin_port = htons(SERVER_PORT);

        if(inet_pton(AF_INET, "127.0.0.1", &server_address.sin_addr) <= 0) {
            perror("Error converting IP address to binary form");
            exit(EXIT_FAILURE);
        }

        sockfd = socket(AF_INET, SOCK_STREAM, 0);
        if(sockfd < 0) {
            perror("Can't create a socket");
            exit(EXIT_FAILURE);
        }

        if(connect(sockfd, (struct sockaddr *)&server_address, sizeof(server_address)) < 0) {
            perror("Connect failed");
            exit(EXIT_FAILURE);
        }

        curl_easy_setopt(curl, CURLOPT_URL, "smtp://127.0.0.1:25");
        curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, WriteCallback);
        curl_easy_setopt(curl, CURLOPT_VERBOSE, 1L);

        res = curl_easy_perform(curl);

        if(res != CURLE_OK) {
            fprintf(stderr, "SMTP client failed: %s\n", curl_easy_strerror(res));
        }

        curl_easy_cleanup(curl);
        close(sockfd);
    }

    return EXIT_SUCCESS;
}