//GEMINI-pro DATASET v1.0 Category: Networking ; Style: realistic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

int main() {
    // Create a socket
    int sockfd = socket(AF_INET, SOCK_STREAM, 0);
    if (sockfd == -1) {
        perror("socket");
        return EXIT_FAILURE;
    }

    // Bind the socket to an address
    struct sockaddr_in addr;
    memset(&addr, 0, sizeof(addr));
    addr.sin_family = AF_INET;
    addr.sin_port = htons(8080);
    addr.sin_addr.s_addr = htonl(INADDR_ANY);
    if (bind(sockfd, (struct sockaddr *)&addr, sizeof(addr)) == -1) {
        perror("bind");
        return EXIT_FAILURE;
    }

    // Listen for incoming connections
    if (listen(sockfd, 5) == -1) {
        perror("listen");
        return EXIT_FAILURE;
    }

    // Accept an incoming connection
    int connfd = accept(sockfd, NULL, NULL);
    if (connfd == -1) {
        perror("accept");
        return EXIT_FAILURE;
    }

    // Read data from the client
    char buffer[1024];
    memset(buffer, 0, sizeof(buffer));
    int n = read(connfd, buffer, sizeof(buffer));
    if (n == -1) {
        perror("read");
        return EXIT_FAILURE;
    }

    // Print the data from the client
    printf("Received: %s\n", buffer);

    // Write data to the client
    const char *msg = "Hello, world!\n";
    if (write(connfd, msg, strlen(msg)) == -1) {
        perror("write");
        return EXIT_FAILURE;
    }

    // Close the connection
    close(connfd);
    close(sockfd);

    return EXIT_SUCCESS;
}