//GEMINI-pro DATASET v1.0 Category: Sorting ; Style: expert-level
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Define the maximum number of elements in the array
#define MAX_SIZE 100

// Define the structure of an element in the array
typedef struct {
    int value;
    char name[30];
} element;

// Define the comparison function for sorting the array
int compare_elements(const void *a, const void *b) {
    // Cast the arguments to the correct type
    const element *element1 = (const element *)a;
    const element *element2 = (const element *)b;

    // Compare the values of the elements
    if (element1->value < element2->value) {
        return -1;
    } else if (element1->value > element2->value) {
        return 1;
    } else {
        // If the values are equal, compare the names
        return strcmp(element1->name, element2->name);
    }
}

int main() {
    // Create an array of elements
    element array[MAX_SIZE];

    // Initialize the array with some values
    for (int i = 0; i < MAX_SIZE; i++) {
        array[i].value = rand() % 100;
        sprintf(array[i].name, "Element %d", i);
    }

    // Sort the array using the qsort function
    qsort(array, MAX_SIZE, sizeof(element), compare_elements);

    // Print the sorted array
    for (int i = 0; i < MAX_SIZE; i++) {
        printf("%d %s\n", array[i].value, array[i].name);
    }

    return 0;
}