//GEMINI-pro DATASET v1.0 Category: Bitwise operations ; Style: authentic
// Welcome to the enigmatic realm of bitwise operations!

#include <stdio.h>
#include <stdlib.h>

// Encrypt a secret message using XOR cipher
char cipher(char c, char key) {
    return c ^ key;
}

// Decipher the encrypted message using the same key
char decipher(char enc_c, char key) {
    return cipher(enc_c, key);
}

// Unravel the mystery of binary patterns
void binary_pattern(int n) {
    if (n == 0) {
        printf("0");
        return;
    }
    printf("%d", n % 2);
    binary_pattern(n / 2);
}

// Calculate the parity of a number (even/odd) using bitwise XOR
int parity(int n) {
    return !(n & 1);
}

// Find the position of the rightmost set bit (1) in a number
int rightmost_set_bit(unsigned int n) {
    if (n == 0) {
        return -1;
    }
    int position = 1;
    while (!(n & 1)) {
        n >>= 1;
        position++;
    }
    return position;
}

int main() {
    // Embark on a bitwise adventure!
    char secret = 'S';
    char key = 'K';
    char encrypted = cipher(secret, key);
    printf("Encrypted secret: %c\n", encrypted);
    printf("Deciphered secret: %c\n", decipher(encrypted, key));

    // Explore the binary realm
    printf("Binary pattern of 123: ");
    binary_pattern(123);
    printf("\n");

    // Unveil the parity of a number
    printf("Is 10 even? %s\n", parity(10) ? "Yes" : "No");
    printf("Is 11 odd? %s\n", parity(11) ? "Yes" : "No");

    // Seek the rightmost set bit
    printf("Rightmost set bit in 15: %d\n", rightmost_set_bit(15));
    printf("Rightmost set bit in 0: %d\n", rightmost_set_bit(0));

    return 0;
}