//GPT-4o-mini DATASET v1.0 Category: Geometric algorithms ; Style: innovative
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define PI 3.14159265358979323846

// Structure to represent a Point
typedef struct {
    double x;
    double y;
} Point;

// Function to create a Point
Point createPoint(double x, double y) {
    Point p;
    p.x = x;
    p.y = y;
    return p;
}

// Function to calculate distance between two Points
double distance(Point p1, Point p2) {
    return sqrt(pow(p2.x - p1.x, 2) + pow(p2.y - p1.y, 2));
}

// Function to calculate the area of a triangle formed by three Points
double triangleArea(Point p1, Point p2, Point p3) {
    return fabs((p1.x*(p2.y - p3.y) + p2.x*(p3.y - p1.y) + p3.x*(p1.y - p2.y)) / 2.0);
}

// Function to check if a Point is inside a triangle
int isInsideTriangle(Point p, Point p1, Point p2, Point p3) {
    double A = triangleArea(p1, p2, p3);
    double A1 = triangleArea(p, p2, p3);
    double A2 = triangleArea(p1, p, p3);
    double A3 = triangleArea(p1, p2, p);
    return (A == A1 + A2 + A3);
}

// Function to calculate the Centroid of a triangle
Point calculateCentroid(Point p1, Point p2, Point p3) {
    Point centroid;
    centroid.x = (p1.x + p2.x + p3.x) / 3;
    centroid.y = (p1.y + p2.y + p3.y) / 3;
    return centroid;
}

// Function to check if a set of Points is convex
int isConvexPolygon(Point points[], int n) {
    if (n < 3) return 0; // Cannot form a polygon

    int direction = 0;
    for (int i = 0; i < n; i++) {
        double crossProduct = (points[(i + 1) % n].x - points[i].x) * 
                              (points[(i + 2) % n].y - points[(i + 1) % n].y) - 
                              (points[(i + 1) % n].y - points[i].y) * 
                              (points[(i + 2) % n].x - points[(i + 1) % n].x);
        if (crossProduct != 0) {
            if (direction == 0) {
                direction = (crossProduct > 0) ? 1 : -1;
            } else if (direction != (crossProduct > 0 ? 1 : -1)) {
                return 0; // Not convex
            }
        }
    }
    return 1; // Convex
}

// Function to print a Point
void printPoint(Point p) {
    printf("Point(%.2f, %.2f)\n", p.x, p.y);
}

// Main function to demonstrate geometric algorithms
int main() {
    Point p1 = createPoint(0, 0);
    Point p2 = createPoint(5, 0);
    Point p3 = createPoint(2.5, 5);

    printf("Points of the triangle:\n");
    printPoint(p1);
    printPoint(p2);
    printPoint(p3);

    printf("Area of the triangle: %.2f\n", triangleArea(p1, p2, p3));

    Point centroid = calculateCentroid(p1, p2, p3);
    printf("Centroid of the triangle:\n");
    printPoint(centroid);

    Point testPoint = createPoint(2.5, 2);
    printf("Testing if Point ");
    printPoint(testPoint);
    printf("is inside the triangle: %s\n", isInsideTriangle(testPoint, p1, p2, p3) ? "Yes" : "No");
    
    // Define a polygon
    Point polygon[] = { createPoint(0, 0), createPoint(4, 0), createPoint(4, 4), createPoint(0, 4) };
    int n = sizeof(polygon) / sizeof(polygon[0]);

    printf("The given polygon is %s\n", isConvexPolygon(polygon, n) ? "Convex" : "Concave");

    return 0;
}