//Falcon-180B DATASET v1.0 Category: System event logger ; Style: sophisticated
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#define MAX_EVENTS 1000
#define EVENT_SIZE 64

typedef struct {
    char message[EVENT_SIZE];
    time_t timestamp;
} Event;

void log_event(const char* message) {
    time_t now = time(NULL);
    Event event = {.message = message,.timestamp = now };

    FILE* log_file = fopen("event_log.txt", "a");
    if (log_file == NULL) {
        printf("Error: Could not open log file.\n");
        return;
    }

    fprintf(log_file, "%s - %ld\n", event.message, event.timestamp);
    fclose(log_file);
}

void print_event_log() {
    FILE* log_file = fopen("event_log.txt", "r");
    if (log_file == NULL) {
        printf("Error: Could not open log file.\n");
        return;
    }

    Event events[MAX_EVENTS];
    int num_events = 0;

    while (fgets(events[num_events].message, EVENT_SIZE, log_file)!= NULL) {
        num_events++;
    }

    fclose(log_file);

    printf("Event log:\n");
    for (int i = 0; i < num_events; i++) {
        printf("%s - %s\n", ctime(&events[i].timestamp), events[i].message);
    }
}

int main() {
    log_event("Program started.");

    //...

    log_event("Program finished.");

    return 0;
}