//Falcon-180B DATASET v1.0 Category: Database simulation ; Style: rigorous
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_ROWS 10
#define MAX_COLS 10

typedef struct {
    char name[MAX_COLS];
    int age;
    char address[MAX_COLS];
} Record;

Record db[MAX_ROWS];
int numRecords = 0;

void addRecord(char *name, int age, char *address) {
    if (numRecords >= MAX_ROWS) {
        printf("Error: Database is full.\n");
        return;
    }
    strcpy(db[numRecords].name, name);
    db[numRecords].age = age;
    strcpy(db[numRecords].address, address);
    numRecords++;
}

void displayRecords() {
    printf("Name\tAge\tAddress\n");
    for (int i = 0; i < numRecords; i++) {
        printf("%s\t%d\t%s\n", db[i].name, db[i].age, db[i].address);
    }
}

void searchRecord(char *name) {
    for (int i = 0; i < numRecords; i++) {
        if (strcmp(db[i].name, name) == 0) {
            printf("Name: %s\nAge: %d\nAddress: %s\n", db[i].name, db[i].age, db[i].address);
            return;
        }
    }
    printf("Record not found.\n");
}

void deleteRecord(char *name) {
    for (int i = 0; i < numRecords; i++) {
        if (strcmp(db[i].name, name) == 0) {
            for (int j = i; j < numRecords - 1; j++) {
                db[j] = db[j + 1];
            }
            numRecords--;
            return;
        }
    }
    printf("Record not found.\n");
}

int main() {
    addRecord("John", 25, "123 Main St.");
    addRecord("Jane", 30, "456 Elm St.");
    displayRecords();
    searchRecord("John");
    deleteRecord("Jane");
    displayRecords();
    return 0;
}