//Falcon-180B DATASET v1.0 Category: Interprocess communication ; Style: thoughtful
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/wait.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <sys/sem.h>
#include <errno.h>

#define SEM_KEY 0x1234
#define SEM_PERM 0666
#define SEM_COUNT 10
#define SHM_KEY 0x5678
#define SHM_SIZE 1024
#define SHM_PERM 0666

int main() {
    int semid, shmid;
    int i;
    char *shmaddr;
    struct sembuf sem_op;

    // Create semaphore
    semid = semget(SEM_KEY, SEM_COUNT, SEM_PERM);
    if (semid == -1) {
        printf("Error: Failed to create semaphore.\n");
        exit(1);
    }

    // Initialize semaphore
    for (i = 0; i < SEM_COUNT; i++) {
        sem_op.sem_num = i;
        sem_op.sem_op = 1;
        sem_op.sem_flg = SEM_UNDO;
        if (semop(semid, &sem_op, 1) == -1) {
            printf("Error: Failed to initialize semaphore.\n");
            exit(1);
        }
    }

    // Create shared memory
    shmid = shmget(SHM_KEY, SHM_SIZE, SHM_PERM);
    if (shmid == -1) {
        printf("Error: Failed to create shared memory.\n");
        exit(1);
    }

    // Attach shared memory
    shmaddr = shmat(shmid, NULL, 0);
    if (shmaddr == (void *) -1) {
        printf("Error: Failed to attach shared memory.\n");
        exit(1);
    }

    // Write to shared memory
    sprintf(shmaddr, "Hello, World!");

    // Detach shared memory
    if (shmdt(shmaddr) == -1) {
        printf("Error: Failed to detach shared memory.\n");
        exit(1);
    }

    // Delete shared memory
    if (shmctl(shmid, IPC_RMID, NULL) == -1) {
        printf("Error: Failed to delete shared memory.\n");
        exit(1);
    }

    // Delete semaphore
    for (i = 0; i < SEM_COUNT; i++) {
        sem_op.sem_num = i;
        sem_op.sem_op = -1;
        sem_op.sem_flg = SEM_UNDO;
        if (semop(semid, &sem_op, 1) == -1) {
            printf("Error: Failed to delete semaphore.\n");
            exit(1);
        }
    }

    return 0;
}