//GEMINI-pro DATASET v1.0 Category: Matrix operations ; Style: puzzling
#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>

// Matrix dimensions
#define ROWS 3
#define COLS 3

// Matrix initialization
int matrix[ROWS][COLS] = {
    {1, 2, 3},
    {4, 5, 6},
    {7, 8, 9}
};

// Function to swap two rows
void swapRows(int matrix[ROWS][COLS], int row1, int row2) {
    for (int col = 0; col < COLS; col++) {
        int temp = matrix[row1][col];
        matrix[row1][col] = matrix[row2][col];
        matrix[row2][col] = temp;
    }
}

// Function to swap two columns
void swapCols(int matrix[ROWS][COLS], int col1, int col2) {
    for (int row = 0; row < ROWS; row++) {
        int temp = matrix[row][col1];
        matrix[row][col1] = matrix[row][col2];
        matrix[row][col2] = temp;
    }
}

// Function to rotate the matrix 90 degrees clockwise
void rotateClockwise(int matrix[ROWS][COLS]) {
    // Transpose the matrix
    for (int row = 0; row < ROWS; row++) {
        for (int col = row; col < COLS; col++) {
            int temp = matrix[row][col];
            matrix[row][col] = matrix[col][row];
            matrix[col][row] = temp;
        }
    }

    // Swap rows
    for (int row = 0; row < ROWS / 2; row++) {
        swapRows(matrix, row, ROWS - row - 1);
    }
}

// Function to rotate the matrix 90 degrees counter-clockwise
void rotateCounterClockwise(int matrix[ROWS][COLS]) {
    // Transpose the matrix
    for (int row = 0; row < ROWS; row++) {
        for (int col = row; col < COLS; col++) {
            int temp = matrix[row][col];
            matrix[row][col] = matrix[col][row];
            matrix[col][row] = temp;
        }
    }

    // Swap columns
    for (int col = 0; col < COLS / 2; col++) {
        swapCols(matrix, col, COLS - col - 1);
    }
}

// Function to print the matrix
void printMatrix(int matrix[ROWS][COLS]) {
    for (int row = 0; row < ROWS; row++) {
        for (int col = 0; col < COLS; col++) {
            printf("%d ", matrix[row][col]);
        }
        printf("\n");
    }
}

// Main function
int main() {
    //Original
    printf("Original Matrix:\n");
    printMatrix(matrix);

    // 90 degrees clockwise rotation
    printf("\n90 Degrees Clockwise Rotation:\n");
    rotateClockwise(matrix);
    printMatrix(matrix);

    // 90 degrees counter-clockwise rotation
    printf("\n90 Degrees Counter-Clockwise Rotation:\n");
    rotateCounterClockwise(matrix);
    printMatrix(matrix);

    return 0;
}