//LLAMA2-13B DATASET v1.0 Category: Database querying ; Style: mathematical
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

// Define the database structure
typedef struct {
    int id;
    double x;
    double y;
} point;

// Define the database
point points[10] = {
    {1, 2.5, 3.2},
    {2, 4.3, 5.7},
    {3, 1.1, 2.3},
    {4, 3.4, 5.6},
    {5, 2.2, 4.1},
    {6, 1.7, 3.9},
    {7, 4.5, 6.8},
    {8, 3.2, 5.1},
    {9, 2.1, 4.7},
    {10, 1.5, 3.6}
};

// Define the query function
int query(double x, double y) {
    int i, j;
    double min_distance = INFINITY;

    for (i = 0; i < 10; i++) {
        for (j = 0; j < 10; j++) {
            if (points[i].x == points[j].x && points[i].y == points[j].y) {
                continue;
            }
            double distance = hypot(points[i].x - x, points[i].y - y);
            if (distance < min_distance) {
                min_distance = distance;
            }
        }
    }

    return min_distance;
}

int main() {
    int i;
    double x = 3.4;
    double y = 5.6;

    for (i = 0; i < 10; i++) {
        printf("%d: (%f, %f)\n", i, points[i].x, points[i].y);
    }

    printf("Minimum distance to (%f, %f) is %f\n", x, y, query(x, y));

    return 0;
}