//GPT-4o-mini DATASET v1.0 Category: Maze Route Finder ; Style: portable
#include <stdio.h>
#include <stdlib.h>

#define N 5

// Function to print the maze
void printMaze(int maze[N][N]) {
    for (int i = 0; i < N; i++) {
        for (int j = 0; j < N; j++) {
            if (maze[i][j] == 1)
                printf(" # ");
            else
                printf(" . ");
        }
        printf("\n");
    }
}

// Utility function to check if x, y is a valid move
int isSafe(int maze[N][N], int x, int y) {
    return (x >= 0 && x < N && y >= 0 && y < N && maze[x][y] == 0);
}

// Recursive function to solve the maze using backtracking
int solveMazeUtil(int maze[N][N], int x, int y, int solution[N][N]) {
    
    // Check if we reached the bottom-right corner (exit)
    if (x == N - 1 && y == N - 1) {
        solution[x][y] = 1;
        return 1;
    }

    // Check if maze[x][y] is valid
    if (isSafe(maze, x, y)) {
        // Mark x, y as part of solution path
        solution[x][y] = 1;

        // Move forward in x direction
        if (solveMazeUtil(maze, x + 1, y, solution))
            return 1;

        // If moving in x direction doesn't give solution then
        // Move down in y direction
        if (solveMazeUtil(maze, x, y + 1, solution))
            return 1;

        // If none of the above movements work then
        // BACKTRACK: unmark x, y as part of solution path
        solution[x][y] = 0;
        return 0;
    }

    return 0;
}

// Function to solve the maze
void solveMaze(int maze[N][N]) {
    int solution[N][N] = { { 0, 0, 0, 0, 0 }, 
                            { 0, 0, 0, 0, 0 }, 
                            { 0, 0, 0, 0, 0 }, 
                            { 0, 0, 0, 0, 0 }, 
                            { 0, 0, 0, 0, 0 } };

    if (solveMazeUtil(maze, 0, 0, solution) == 0) {
        printf("Solution doesn't exist\n");
        return;
    }

    printMaze(solution);
}

// Main driver function
int main() {
    // A 5x5 maze
    int maze[N][N] = { { 0, 1, 0, 0, 0 },
                       { 0, 1, 0, 1, 0 },
                       { 0, 0, 0, 1, 0 },
                       { 1, 1, 0, 0, 0 },
                       { 0, 0, 1, 1, 0 } };

    printf("The original maze:\n");
    printMaze(maze);
    printf("\nFinding a way out of the maze:\n");
    solveMaze(maze);

    return 0;
}