//Gemma-7B DATASET v1.0 Category: Scientific Calculator Implementation ; Style: lively
#include <stdio.h>
#include <stdlib.h>

#define MAX_BUFFER_SIZE 1024

typedef struct Calculator {
    char buffer[MAX_BUFFER_SIZE];
    int top;
    double result;
} Calculator;

void calculator_init(Calculator *calc) {
    calc->top = -1;
    calc->result = 0.0;
    calc->buffer[0] = '\0';
}

void calculator_push(Calculator *calc, char num) {
    calc->buffer[++calc->top] = num;
}

double calculator_pop(Calculator *calc) {
    if (calc->top == -1) {
        return -1;
    }
    return calc->buffer[calc->top--];
}

void calculator_clear(Calculator *calc) {
    calc->top = -1;
    calc->result = 0.0;
    calc->buffer[0] = '\0';
}

double calculator_evaluate(Calculator *calc) {
    double num1, num2, operator;
    char operator_str[2];

    switch (calc->buffer[calc->top]) {
        case '+':
            operator_str[0] = '+';
            num1 = calculator_pop(calc);
            num2 = calculator_pop(calc);
            calc->result = num1 + num2;
            break;
        case '-':
            operator_str[0] = '-';
            num1 = calculator_pop(calc);
            num2 = calculator_pop(calc);
            calc->result = num1 - num2;
            break;
        case '*':
            operator_str[0] = '*';
            num1 = calculator_pop(calc);
            num2 = calculator_pop(calc);
            calc->result = num1 * num2;
            break;
        case '/':
            operator_str[0] = '/';
            num1 = calculator_pop(calc);
            num2 = calculator_pop(calc);
            calc->result = num1 / num2;
            break;
        default:
            return -1;
    }

    return calc->result;
}

int main() {
    Calculator calc;
    calculator_init(&calc);

    // Calculate 5 + 10 = 15
    calculator_push(&calc, '5');
    calculator_push(&calc, '+');
    calculator_push(&calc, '10');
    calculator_push(&calc, '=');

    double result = calculator_evaluate(&calc);
    printf("The result is: %.2lf\n", result);

    // Calculate 20 - 5 = 15
    calculator_clear(&calc);
    calculator_push(&calc, '20');
    calculator_push(&calc, '-');
    calculator_push(&calc, '5');
    calculator_push(&calc, '=');

    result = calculator_evaluate(&calc);
    printf("The result is: %.2lf\n", result);

    return 0;
}