//MISTRAL-7B DATASET v1.0 Category: Interprocess communication ; Style: unmistakable
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <string.h>
#include <sys/types.h>
#include <sys/wait.h>

#define PIPE_NAME "magic_fantasy_pipe"

int main(int argc, char *argv[]) {
  int fd[2]; // File Descriptors for Pipe
  pid_t pid;
  char message[100];
  char response[100];

  // Create a Pipe
  if (pipe(fd) < 0) {
    perror("Pipe Failed");
    return EXIT_FAILURE;
  }

  // Fork a Child Process
  pid = fork();

  if (pid < 0) { // Error occurred
    perror("Fork Failed");
    close(fd[0]);
    close(fd[1]);
    return EXIT_FAILURE;
  } else if (pid > 0) { // Parent Process
    close(fd[0]); // Close Reading End
    close(STDOUT_FILENO); // Close Standard Output
    dup2(fd[1], STDOUT_FILENO); // Redirect Writing End to Standard Output

    // Write a Message to Child Process and Wait for Response
    strcpy(message, "Once upon a time in a magical land...");
    write(STDOUT_FILENO, message, strlen(message));
    close(fd[1]);

    wait(NULL); // Wait for Child Process to Finish

    // Read Response from Child Process
    read(fd[0], response, sizeof(response));
    close(fd[0]);

    printf("\nChild's Response: %s", response);
  } else { // Child Process
    close(fd[1]); // Close Writing End

    // Read Message from Parent Process and Create Response
    read(fd[0], message, sizeof(message));
    close(fd[0]);

    strcpy(response, "And they all lived happily ever after.");
    write(STDOUT_FILENO, response, strlen(response));

    exit(EXIT_SUCCESS);
  }

  return EXIT_SUCCESS;
}