//GPT-4o-mini DATASET v1.0 Category: Secure Password Generator ; Style: retro
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>

#define PASSWORD_LENGTH 12
#define NUM_PASSWORDS 5

const char* upper = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
const char* lower = "abcdefghijklmnopqrstuvwxyz";
const char* digits = "0123456789";
const char* symbols = "!@#$%^&*()-_+=<>?";

void shuffle(char *array, int n) {
    for (int i = n - 1; i > 0; i--) {
        int j = rand() % (i + 1);
        char temp = array[i];
        array[i] = array[j];
        array[j] = temp;
    }
}

void generatePassword(char *password) {
    int i = 0;
    password[i++] = upper[rand() % strlen(upper)];  // At least one uppercase
    password[i++] = lower[rand() % strlen(lower)];  // At least one lowercase
    password[i++] = digits[rand() % strlen(digits)]; // At least one digit
    password[i++] = symbols[rand() % strlen(symbols)]; // At least one symbol

    // Fill remaining length of password with random characters from all character sets
    const char* all_characters = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!@#$%^&*()-_+=<>?";
    for (; i < PASSWORD_LENGTH; i++) {
        password[i] = all_characters[rand() % strlen(all_characters)];
    }
    
    password[PASSWORD_LENGTH] = '\0'; // Null-terminate the string
    shuffle(password, PASSWORD_LENGTH); // Shuffle the result
}

int main() {
    srand(time(NULL)); // Seed for random number generation

    printf("------------------------------------------------\n");
    printf("             Retro Secure Password Generator     \n");
    printf("------------------------------------------------\n");
    printf("Generating %d secure passwords of length %d...\n\n", NUM_PASSWORDS, PASSWORD_LENGTH);

    for (int i = 0; i < NUM_PASSWORDS; i++) {
        char password[PASSWORD_LENGTH + 1];
        generatePassword(password);
        printf("Password %d: %s\n", i + 1, password);
    }

    printf("\n------------------------------------------------\n");
    printf("           Use these passwords wisely!          \n");
    printf("------------------------------------------------\n");
    return 0;
}