//Falcon-180B DATASET v1.0 Category: Building a IMAP Client ; Style: multi-threaded
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <pthread.h>
#include <curl/curl.h>

#define THREAD_COUNT 2
#define IMAP_SERVER "imap.gmail.com"
#define IMAP_PORT 993
#define IMAP_USER "your_email@gmail.com"
#define IMAP_PASS "your_password"

typedef struct {
    char *email;
    char *subject;
    char *body;
} Email;

Email emails[10];

size_t WriteCallback(void *contents, size_t size, size_t nmemb, void *userp) {
    char *buffer = (char *)malloc(size * nmemb);
    memcpy(buffer, contents, size * nmemb);
    strcat(emails[0].body, buffer);
    free(buffer);
    return size * nmemb;
}

void *ThreadFunc(void *param) {
    char url[100];
    sprintf(url, "imap://%s:%s@%s:%d", IMAP_USER, IMAP_PASS, IMAP_SERVER, IMAP_PORT);
    CURL *curl;
    CURLcode res;

    curl_global_init(CURL_GLOBAL_DEFAULT);
    curl = curl_easy_init();

    if(curl) {
        curl_easy_setopt(curl, CURLOPT_URL, url);
        curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, WriteCallback);
        res = curl_easy_perform(curl);

        if(res!= CURLE_OK)
            fprintf(stderr, "curl_easy_perform() failed: %s\n",
                    curl_easy_strerror(res));

        curl_easy_cleanup(curl);
    }

    curl_global_cleanup();
    return NULL;
}

int main() {
    pthread_t threads[THREAD_COUNT];

    for (int i = 0; i < THREAD_COUNT; i++) {
        pthread_create(&threads[i], NULL, ThreadFunc, NULL);
    }

    for (int i = 0; i < THREAD_COUNT; i++) {
        pthread_join(threads[i], NULL);
    }

    for (int i = 0; i < 10; i++) {
        printf("Email %d:\n", i+1);
        printf("From: %s\n", emails[i].email);
        printf("Subject: %s\n", emails[i].subject);
        printf("Body: %s\n", emails[i].body);
        printf("\n");
    }

    return 0;
}