//GEMINI-pro DATASET v1.0 Category: Database simulation ; Style: secure
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Define the maximum number of records in the database
#define MAX_RECORDS 100

// Define the maximum length of a record
#define MAX_RECORD_LENGTH 100

// Define the structure of a record
typedef struct {
  int id;
  char name[MAX_RECORD_LENGTH];
  char address[MAX_RECORD_LENGTH];
} record;

// Define the database
record database[MAX_RECORDS];

// Define the current number of records in the database
int num_records = 0;

// Function to add a record to the database
void add_record(int id, char *name, char *address) {
  // Check if the database is full
  if (num_records >= MAX_RECORDS) {
    printf("Error: Database is full\n");
    return;
  }

  // Add the record to the database
  database[num_records].id = id;
  strcpy(database[num_records].name, name);
  strcpy(database[num_records].address, address);

  // Increment the number of records in the database
  num_records++;
}

// Function to delete a record from the database
void delete_record(int id) {
  // Find the record with the given ID
  int i;
  for (i = 0; i < num_records; i++) {
    if (database[i].id == id) {
      break;
    }
  }

  // Check if the record was found
  if (i == num_records) {
    printf("Error: Record not found\n");
    return;
  }

  // Delete the record
  for (i = i + 1; i < num_records; i++) {
    database[i - 1] = database[i];
  }

  // Decrement the number of records in the database
  num_records--;
}

// Function to print the database
void print_database() {
  // Print the header
  printf("ID\tName\t\tAddress\n");

  // Print the records
  int i;
  for (i = 0; i < num_records; i++) {
    printf("%d\t%s\t\t%s\n", database[i].id, database[i].name, database[i].address);
  }
}

// Main function
int main() {
  // Add some records to the database
  add_record(1, "John Doe", "123 Main Street");
  add_record(2, "Jane Doe", "456 Elm Street");
  add_record(3, "John Smith", "789 Oak Street");

  // Print the database
  print_database();

  // Delete a record from the database
  delete_record(2);

  // Print the database
  print_database();

  return 0;
}