//GEMINI-pro DATASET v1.0 Category: TCP/IP Programming ; Style: all-encompassing
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

int main() {

    // Create a socket
    int sock = socket(AF_INET, SOCK_STREAM, 0);
    if (sock == -1) {
        perror("socket");
        exit(1);
    }

    // Bind the socket to an address and port
    struct sockaddr_in addr;
    memset(&addr, 0, sizeof(addr));
    addr.sin_family = AF_INET;
    addr.sin_port = htons(8080);
    addr.sin_addr.s_addr = INADDR_ANY;
    if (bind(sock, (struct sockaddr *)&addr, sizeof(addr)) == -1) {
        perror("bind");
        exit(1);
    }

    // Listen for connections
    if (listen(sock, 5) == -1) {
        perror("listen");
        exit(1);
    }

    // Accept a connection
    struct sockaddr_in client_addr;
    socklen_t client_addr_len = sizeof(client_addr);
    int client_sock = accept(sock, (struct sockaddr *)&client_addr, &client_addr_len);
    if (client_sock == -1) {
        perror("accept");
        exit(1);
    }

    // Read data from the client
    char buffer[1024];
    memset(buffer, 0, sizeof(buffer));
    int n = read(client_sock, buffer, sizeof(buffer));
    if (n == -1) {
        perror("read");
        exit(1);
    }

    // Send data back to the client
    char *response = "HTTP/1.1 200 OK\r\nContent-Type: text/html\r\n\r\n<h1>Hello, world!</h1>";
    if (write(client_sock, response, strlen(response)) == -1) {
        perror("write");
        exit(1);
    }

    // Close the client socket
    close(client_sock);

    // Close the server socket
    close(sock);

    return 0;
}