//Code Llama-13B DATASET v1.0 Category: TCP/IP Programming ; Style: high level of detail
/*
 * TCP/IP Programming Example
 *
 * This program demonstrates a simple TCP/IP client-server
 * communication using the Berkeley Sockets API.
 *
 * Author: [Your Name]
 * Date: [Current Date]
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>

// Port number used by the server
#define SERVER_PORT 8080

// Maximum number of client connections
#define MAX_CLIENTS 10

// Function to handle client connections
void handle_client(int client_sock) {
    // Receive message from client
    char buffer[256];
    recv(client_sock, buffer, sizeof(buffer), 0);

    // Print received message
    printf("Received message from client: %s\n", buffer);

    // Send response to client
    char response[] = "Hello, client!";
    send(client_sock, response, sizeof(response), 0);

    // Close client socket
    close(client_sock);
}

int main() {
    // Create a new socket
    int server_sock = socket(AF_INET, SOCK_STREAM, 0);

    // Set up address structure
    struct sockaddr_in server_addr;
    server_addr.sin_family = AF_INET;
    server_addr.sin_addr.s_addr = INADDR_ANY;
    server_addr.sin_port = htons(SERVER_PORT);

    // Bind the socket to the address
    bind(server_sock, (struct sockaddr *)&server_addr, sizeof(server_addr));

    // Listen for incoming connections
    listen(server_sock, MAX_CLIENTS);

    // Accept incoming connections
    int client_sock = accept(server_sock, NULL, NULL);

    // Handle the client connection
    handle_client(client_sock);

    // Close the server socket
    close(server_sock);

    return 0;
}