//GEMINI-pro DATASET v1.0 Category: Image Editor ; Style: realistic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

typedef struct {
    unsigned char *data;
    int width, height, channels;
} Image;

Image *load_image(const char *filename) {
    FILE *fp = fopen(filename, "rb");
    if (!fp) {
        fprintf(stderr, "Error opening file: %s\n", filename);
        return NULL;
    }

    fseek(fp, 0, SEEK_END);
    long size = ftell(fp);
    fseek(fp, 0, SEEK_SET);

    unsigned char *data = (unsigned char *)malloc(size);
    if (!data) {
        fprintf(stderr, "Error allocating memory for image data\n");
        fclose(fp);
        return NULL;
    }

    fread(data, 1, size, fp);
    fclose(fp);

    Image *image = (Image *)malloc(sizeof(Image));
    if (!image) {
        fprintf(stderr, "Error allocating memory for image struct\n");
        free(data);
        return NULL;
    }

    image->data = data;
    image->width = 0;
    image->height = 0;
    image->channels = 0;

    return image;
}

void save_image(const char *filename, Image *image) {
    FILE *fp = fopen(filename, "wb");
    if (!fp) {
        fprintf(stderr, "Error opening file: %s\n", filename);
        return;
    }

    fwrite(image->data, 1, image->width * image->height * image->channels, fp);
    fclose(fp);
}

void invert_colors(Image *image) {
    for (int i = 0; i < image->width * image->height * image->channels; i++) {
        image->data[i] = 255 - image->data[i];
    }
}

void grayscale(Image *image) {
    for (int i = 0; i < image->width * image->height * image->channels; i++) {
        unsigned char gray = (image->data[i] + image->data[i + 1] + image->data[i + 2]) / 3;
        image->data[i] = gray;
        image->data[i + 1] = gray;
        image->data[i + 2] = gray;
    }
}

void blur(Image *image, int radius) {
    int newImage[image->width][image->height][image->channels];
    int channelSize = image->channels*image->width*image->height;
   for (int i = 0; i < image->width; i++) {
        for (int j = 0; j < image->height; j++) {
            for (int k = 0; k < image->channels; k++) {
                int sum=0;
                for (int x = -radius; x <= radius; x++) {
                    for (int y = -radius; y <= radius; y++) {
                        if (i + x >= 0 && i + x < image->width && j + y >= 0 && j + y < image->height) {
                            sum += image->data[((i + x) * image->width + (j + y)) * image->channels + k];
                        }
                    }
                }
                int average = sum / ((2 * radius + 1) * (2 * radius + 1));
                newImage[i][j][k]=average;
            }
        }
    }
    int counter=0;
    for (int i = 0; i < image->width; i++) {
        for (int j = 0; j < image->height; j++) {
            for (int k = 0; k < image->channels; k++) {
                image->data[counter]=newImage[i][j][k];
                counter++;
            }
        }
    }
}

void sharpen(Image *image, int radius) {
    int newImage[image->width][image->height][image->channels];
    int channelSize = image->channels*image->width*image->height;
   for (int i = 0; i < image->width; i++) {
        for (int j = 0; j < image->height; j++) {
            for (int k = 0; k < image->channels; k++) {
                int sum=0;
                for (int x = -radius; x <= radius; x++) {
                    for (int y = -radius; y <= radius; y++) {
                        if (i + x >= 0 && i + x < image->width && j + y >= 0 && j + y < image->height) {
                            sum += image->data[((i + x) * image->width + (j + y)) * image->channels + k];
                        }
                    }
                }
                int average = sum / ((2 * radius + 1) * (2 * radius + 1));
                int diff=image->data[((i) * image->width + (j)) * image->channels + k]-average;
                int sharpened = average + diff * 2;
                if (sharpened > 255) sharpened = 255;
                if (sharpened < 0) sharpened = 0;
                newImage[i][j][k]=sharpened;
            }
        }
    }
    int counter=0;
    for (int i = 0; i < image->width; i++) {
        for (int j = 0; j < image->height; j++) {
            for (int k = 0; k < image->channels; k++) {
                image->data[counter]=newImage[i][j][k];
                counter++;
            }
        }
    }
}

int main(int argc, char **argv) {
    if (argc < 2) {
        fprintf(stderr, "Usage: %s <image file>\n", argv[0]);
        return 1;
    }

    char *filename = argv[1];

    Image *image = load_image(filename);
    if (!image) {
        return 1;
    }

    // Apply filters

    invert_colors(image);
    grayscale(image);
    blur(image, 3);
    sharpen(image, 2);
    

    save_image("output.png", image);

    free(image->data);
    free(image);

    return 0;
}