//Falcon-180B DATASET v1.0 Category: Network Packet Monitoring ; Style: thoughtful
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <pcap.h>

#define MAX_SIZE 65536 // Maximum size of a packet

typedef struct {
    u_char *data; // Pointer to packet data
    size_t size; // Size of packet data
} Packet;

void process_packet(u_char *args, const struct pcap_pkthdr *header, const u_char *packet) {
    Packet *pkt = (Packet*) args;
    pkt->data = (u_char*) malloc(header->caplen);
    pkt->size = header->caplen;
    memcpy(pkt->data, packet, header->caplen);
}

int main() {
    char *dev = "eth0"; // Network interface to monitor
    char errbuf[PCAP_ERRBUF_SIZE]; // Buffer for error messages
    pcap_t *handle; // Packet capture handle
    Packet packet; // Packet data structure

    // Open the network interface for monitoring
    handle = pcap_open_live(dev, BUFSIZ, 0, -1, errbuf);

    if (handle == NULL) {
        printf("Error opening network interface: %s\n", errbuf);
        exit(1);
    }

    // Compile and apply a filter to capture only TCP packets
    char filter_str[] = "tcp";
    struct bpf_program fp;
    if (pcap_compile(handle, &fp, filter_str, 0, PCAP_NETMASK_UNKNOWN)!= 0) {
        printf("Error compiling filter: %s\n", pcap_geterr(handle));
        exit(1);
    }

    if (pcap_setfilter(handle, &fp)!= 0) {
        printf("Error setting filter: %s\n", pcap_geterr(handle));
        exit(1);
    }

    // Start capturing packets
    pcap_loop(handle, -1, process_packet, (u_char*) &packet);

    // Close the packet capture handle
    pcap_close(handle);

    return 0;
}