//GEMINI-pro DATASET v1.0 Category: Bucket Sort Implementation ; Style: scientific
#include <stdio.h>
#include <stdlib.h>

#define MAX_SIZE 100

// Function to sort an array using bucket sort
void bucketSort(int arr[], int n) {
  // Create n empty buckets
  int buckets[n];
  for (int i = 0; i < n; i++) {
    buckets[i] = 0;
  }

  // Distribute elements into buckets
  for (int i = 0; i < n; i++) {
    int bucketIndex = arr[i] / n;
    buckets[bucketIndex]++;
  }

  // Sort elements in each bucket
  for (int i = 0; i < n; i++) {
    int bucketIndex = arr[i] / n;
    int j = 0;
    while (j < buckets[bucketIndex]) {
      if (arr[i] < arr[j]) {
        int temp = arr[i];
        arr[i] = arr[j];
        arr[j] = temp;
      }
      j++;
    }
  }
}

// Function to print an array
void printArray(int arr[], int n) {
  for (int i = 0; i < n; i++) {
    printf("%d ", arr[i]);
  }
  printf("\n");
}

// Main function
int main() {
  int arr[] = {3, 8, 5, 1, 9, 2, 6, 7, 4, 0};
  int n = sizeof(arr) / sizeof(arr[0]);

  printf("Unsorted array: ");
  printArray(arr, n);

  bucketSort(arr, n);

  printf("Sorted array: ");
  printArray(arr, n);

  return 0;
}