//GEMINI-pro DATASET v1.0 Category: Bitwise operations ; Style: interoperable
#include <stdio.h>
#include <stdlib.h>

// Custom bitwise operation: Rotate left by n bits
unsigned int rotl(unsigned int x, int n) {
    return (x << n) | (x >> (32 - n));
}

// Custom bitwise operation: Rotate right by n bits
unsigned int rotr(unsigned int x, int n) {
    return (x >> n) | (x << (32 - n));
}

// Custom bitwise operation: Reverse the order of bits
unsigned int reverse_bits(unsigned int x) {
    unsigned int result = 0;
    for (int i = 0; i < 32; i++) {
        result |= ((x >> i) & 1) << (31 - i);
    }
    return result;
}

// Custom bitwise operation: Set the nth bit to 1
unsigned int set_bit(unsigned int x, int n) {
    return x | (1 << n);
}

// Custom bitwise operation: Clear the nth bit to 0
unsigned int clear_bit(unsigned int x, int n) {
    return x & ~(1 << n);
}

// Custom bitwise operation: Toggle the nth bit
unsigned int toggle_bit(unsigned int x, int n) {
    return x ^ (1 << n);
}

// Custom bitwise operation: Check if the nth bit is set
int is_bit_set(unsigned int x, int n) {
    return (x >> n) & 1;
}

int main() {
    // Example usage of custom bitwise operations
    unsigned int x = 0x12345678;
    printf("Original: %08x\n", x);

    // Rotate left by 3 bits
    x = rotl(x, 3);
    printf("Rotate left by 3: %08x\n", x);

    // Rotate right by 5 bits
    x = rotr(x, 5);
    printf("Rotate right by 5: %08x\n", x);

    // Reverse the order of bits
    x = reverse_bits(x);
    printf("Reverse bits: %08x\n", x);

    // Set the 10th bit to 1
    x = set_bit(x, 10);
    printf("Set bit 10: %08x\n", x);

    // Clear the 15th bit to 0
    x = clear_bit(x, 15);
    printf("Clear bit 15: %08x\n", x);

    // Toggle the 20th bit
    x = toggle_bit(x, 20);
    printf("Toggle bit 20: %08x\n", x);

    // Check if the 25th bit is set
    int is_set = is_bit_set(x, 25);
    printf("Bit 25 is set: %d\n", is_set);

    return 0;
}