//GPT-4o-mini DATASET v1.0 Category: Browser Plugin ; Style: shocked
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <curl/curl.h>

#define BUFFER_SIZE 2048

// Struct to hold the response data from the web requests
struct string {
    char *ptr;
    size_t len;
};

// Initialize the string structure
void init_string(struct string *s) {
    s->len = 0;
    s->ptr = malloc(s->len + 1);
    if (s->ptr == NULL) {
        fprintf(stderr, "malloc() failed!\n");
        exit(EXIT_FAILURE);
    }
    s->ptr[0] = '\0';
}

// Callback function to write response data into our string struct
size_t write_callback(void *ptr, size_t size, size_t nmemb, struct string *s) {
    size_t new_len = s->len + size * nmemb;
    s->ptr = realloc(s->ptr, new_len + 1);
    if (s->ptr == NULL) {
        fprintf(stderr, "realloc() failed!\n");
        exit(EXIT_FAILURE);
    }
    memcpy(s->ptr + s->len, ptr, size * nmemb);
    s->ptr[new_len] = '\0';
    s->len = new_len;
    return size * nmemb;
}

// Function that fetches a web page's HTML content
void fetch_page_html(const char *url) {
    CURL *curl;
    CURLcode res;
    struct string response;

    init_string(&response);

    curl_global_init(CURL_GLOBAL_DEFAULT);
    curl = curl_easy_init();
    if(curl) {
        curl_easy_setopt(curl, CURLOPT_URL, url);
        curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, write_callback);
        curl_easy_setopt(curl, CURLOPT_WRITEDATA, &response);
        curl_easy_setopt(curl, CURLOPT_USERAGENT, "C-Browser-Plugin-Example");

        res = curl_easy_perform(curl);
        if(res != CURLE_OK) {
            fprintf(stderr, "curl_easy_perform() failed: %s\n", curl_easy_strerror(res));
        } else {
            printf("Fetched content from %s!\n", url);
            printf("Response Length: %zu bytes\n", response.len);
            printf("Response Data:\n%s\n", response.ptr);
        }

        curl_easy_cleanup(curl);
    }
    free(response.ptr);
    curl_global_cleanup();
}

// Main entry point
int main(int argc, char *argv[]) {
    if (argc < 2) {
        fprintf(stderr, "Usage: %s <URL>\n", argv[0]);
        return EXIT_FAILURE;
    }

    const char *url = argv[1];

    // Startle the user with shocking visual characters!
    for (int i = 0; i < 5; i++) {
        printf("\n!SHOCKING! Fetching %s...\n", url);
        sleep(1);
    }

    fetch_page_html(url);

    // More shocking effects!
    printf("\n,,,***STOP!!***,,, Imagine what's happening in the deep web...\n");
    for (int i = 0; i < 3; i++) {
        printf("...OH NO!...\n");
        sleep(1);
    }

    printf("\nMake sure to browse with care, or you might see the unexpected!\n");
    return EXIT_SUCCESS;
}