//LLAMA2-13B DATASET v1.0 Category: Compression algorithms ; Style: satisfied
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_LENGTH 1024
#define REPEAT_THRESHOLD 4

void compress(char *input, int length) {
  int i, j, repeat;
  char buffer[MAX_LENGTH];

  // Step 1: Find repeats
  for (i = 0; i < length; i++) {
    repeat = 1;
    for (j = i + 1; j < length; j++) {
      if (input[i] != input[j]) {
        repeat = 0;
        break;
      }
    }
    if (repeat > REPEAT_THRESHOLD) {
      // Repeat found!
      buffer[0] = input[i];
      for (j = 1; j < repeat; j++) {
        buffer[j] = input[i];
      }
      input[i] = buffer[0];
      length -= repeat;
      i -= repeat;
    }
  }

  // Step 2: Compress remaining characters
  for (i = 0; i < length; i++) {
    char c = input[i];
    if (c == ' ' || c == '\t' || c == '\r' || c == '\n') {
      // Compress whitespace
      if (i > 0 && input[i - 1] == c) {
        input[i - 1] = ' ';
      } else {
        input[i] = ' ';
      }
    } else if (c >= 'a' && c <= 'z') {
      // Compress lowercase letters
      input[i] = c + (c - 'a' + 'A');
    } else if (c >= 'A' && c <= 'Z') {
      // Compress uppercase letters
      input[i] = c + (c - 'A' + 'a');
    }
  }
}

int main() {
  char input[] = "The quick brown fox jumps over the lazy dog";
  int length = strlen(input);

  compress(input, length);

  printf("%s\n", input);

  return 0;
}