//LLAMA2-13B DATASET v1.0 Category: Unit converter ; Style: mathematical
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

// Define a struct for each unit type
struct length {
    double meters;
    double kilometers;
    double miles;
};

struct weight {
    double grams;
    double kilograms;
    double pounds;
};

struct temperature {
    double celsius;
    double fahrenheit;
    double kelvin;
};

// Define a function to convert between units
void convert(struct length *l, struct weight *w, struct temperature *t) {
    // Convert length
    if (l->meters == 0) {
        l->kilometers = 0;
        l->miles = 0;
    } else {
        l->kilometers = l->meters * 1000;
        l->miles = l->meters * 1.60934;
    }

    // Convert weight
    if (w->grams == 0) {
        w->kilograms = 0;
        w->pounds = 0;
    } else {
        w->kilograms = w->grams / 1000;
        w->pounds = w->kilograms * 2.20462;
    }

    // Convert temperature
    if (t->celsius == 0) {
        t->fahrenheit = 0;
        t->kelvin = 0;
    } else {
        t->fahrenheit = t->celsius * 1.8 + 32;
        t->kelvin = t->celsius + 273.15;
    }
}

int main() {
    struct length l = {10, 0, 0};
    struct weight w = {50, 0, 0};
    struct temperature t = {20, 0, 0};

    convert(&l, &w, &t);

    printf("Length: %f meters, %f kilometers, %f miles\n", l.meters, l.kilometers, l.miles);
    printf("Weight: %f grams, %f kilograms, %f pounds\n", w.grams, w.kilograms, w.pounds);
    printf("Temperature: %f celsius, %f fahrenheit, %f kelvin\n", t.celsius, t.fahrenheit, t.kelvin);

    return 0;
}