//Gemma-7B DATASET v1.0 Category: URL Sanitizer ; Style: distributed
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_URL_LENGTH 255

void sanitize_url(char *url)
{
    char *p = url;
    char *q = strchr(url, '?');
    char *r = strchr(url, '#');

    // Remove query parameters and fragments
    if (q)
    {
        *q = '\0';
    }
    if (r)
    {
        *r = '\0';
    }

    // Normalize case and remove special characters
    while (*p)
    {
        if (!isalnum(*p) && *p != '-' && *p != '_')
        {
            *p = '\0';
        }
        *p = tolower(*p);
        p++;
    }

    // Limit URL length
    if (strlen(url) > MAX_URL_LENGTH)
    {
        url[MAX_URL_LENGTH] = '\0';
    }
}

int main()
{
    char url[MAX_URL_LENGTH] = "This is a sample URL with query parameters and a fragment#!";

    sanitize_url(url);

    printf("Sanitized URL: %s\n", url);

    return 0;
}