//Code Llama-13B DATASET v1.0 Category: Network Ping Test ; Style: post-apocalyptic
/*
 * Apocalyptic Ping Test
 *
 * By: Anonymous
 *
 * In a post-apocalyptic world, a group of survivors must find a way to communicate with the outside world.
 * This program is an example of how they might do so using the ICMP protocol.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#define PING_DEST "8.8.8.8"
#define PING_TIMEOUT 5
#define PING_PACKET_SIZE 64

int main(int argc, char *argv[]) {
    int sockfd;
    struct sockaddr_in servaddr;
    char packet[PING_PACKET_SIZE];
    int packet_len = sizeof(packet);
    char recv_packet[PING_PACKET_SIZE];
    int recv_packet_len = sizeof(recv_packet);
    struct timeval timeout;
    timeout.tv_sec = PING_TIMEOUT;
    timeout.tv_usec = 0;

    // Create a UDP socket
    if ((sockfd = socket(AF_INET, SOCK_DGRAM, 0)) < 0) {
        perror("socket creation failed");
        exit(EXIT_FAILURE);
    }

    // Set the destination address
    memset(&servaddr, 0, sizeof(servaddr));
    servaddr.sin_family = AF_INET;
    servaddr.sin_addr.s_addr = inet_addr(PING_DEST);
    servaddr.sin_port = htons(1);  // port 1 is the standard ICMP echo port

    // Send a ICMP echo request packet
    if (sendto(sockfd, packet, packet_len, 0, (struct sockaddr *) &servaddr, sizeof(servaddr)) < 0) {
        perror("sendto failed");
        exit(EXIT_FAILURE);
    }

    // Set a timeout for receiving the response
    if (setsockopt(sockfd, SOL_SOCKET, SO_RCVTIMEO, &timeout, sizeof(timeout)) < 0) {
        perror("setsockopt failed");
        exit(EXIT_FAILURE);
    }

    // Receive the response
    if (recvfrom(sockfd, recv_packet, recv_packet_len, 0, (struct sockaddr *) &servaddr, &recv_packet_len) < 0) {
        perror("recvfrom failed");
        exit(EXIT_FAILURE);
    }

    // Print the response
    printf("Received response from %s: %s\n", inet_ntoa(servaddr.sin_addr), recv_packet);

    close(sockfd);
    return EXIT_SUCCESS;
}