//GEMINI-pro DATASET v1.0 Category: Building a HTTP Client ; Style: immersive
// Let's embark on an adventure in the realm of HTTP clients!

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <curl/curl.h>

// Defining our own data structure to store the response
typedef struct {
  char *data;
  size_t size;
} ResponseData;

// A function to write the incoming data to our ResponseData structure
size_t write_data(char *ptr, size_t size, size_t nmemb, ResponseData *data) {
  // Calculating the total size of the incoming data
  size_t total_size = size * nmemb;
  // Reallocating memory for the response data if necessary
  data->data = realloc(data->data, data->size + total_size + 1);
  // Copying the incoming data into our response data structure
  memcpy(data->data + data->size, ptr, total_size);
  // Updating the size of our response data structure
  data->size += total_size;
  // Null-terminating our response data for easy handling
  data->data[data->size] = '\0';
  // Returning the size of the incoming data
  return total_size;
}

// Our main function, where the HTTP adventure begins
int main() {
  // Initializing our CURL instance
  CURL *curl = curl_easy_init();
  if (!curl) {
    fprintf(stderr, "Failed to initialize CURL!\n");
    return 1;
  }

  // Setting up our HTTP request options
  curl_easy_setopt(curl, CURLOPT_URL, "https://example.com");
  curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, write_data);

  // Setting up our ResponseData structure to store the response
  ResponseData response_data = {NULL, 0};
  curl_easy_setopt(curl, CURLOPT_WRITEDATA, &response_data);

  // Making our HTTP request
  CURLcode result = curl_easy_perform(curl);
  if (result != CURLE_OK) {
    fprintf(stderr, "Failed to perform HTTP request: %s\n", curl_easy_strerror(result));
    curl_easy_cleanup(curl);
    free(response_data.data);
    return 1;
  }

  // Retrieving the HTTP response code
  long response_code;
  curl_easy_getinfo(curl, CURLINFO_RESPONSE_CODE, &response_code);

  // Displaying the HTTP response status
  printf("HTTP Response Code: %ld\n", response_code);

  // Displaying the HTTP response body
  printf("HTTP Response Body:\n%s", response_data.data);

  // Cleaning up our resources
  curl_easy_cleanup(curl);
  free(response_data.data);
  return 0;
}