//GPT-4o-mini DATASET v1.0 Category: Maze Route Finder ; Style: relaxed
#include <stdio.h>
#include <stdlib.h>

#define N 5 // Maze size

// Function prototypes
void printMaze(int maze[N][N], int sol[N][N]);
int isSafe(int maze[N][N], int x, int y);
int solveMazeUtil(int maze[N][N], int x, int y, int sol[N][N]);
int solveMaze(int maze[N][N]);

// Main code execution
int main() {
    // Sample maze to solve
    int maze[N][N] = {
        { 1, 0, 0, 0, 0 },
        { 1, 1, 0, 1, 1 },
        { 0, 1, 0, 0, 0 },
        { 0, 1, 1, 1, 1 },
        { 0, 0, 0, 0, 1 }
    };

    // Call to solve maze
    if (solveMaze(maze) == 0) {
        printf("No solution exists!\n");
    } else {
        printf("Here is the solution path:\n");
    }

    return 0;
}

// Function to check if x, y is a valid move
int isSafe(int maze[N][N], int x, int y) {
    return (x >= 0 && x < N && y >= 0 && y < N && maze[x][y] == 1);
}

// Function to print the maze solution
void printMaze(int maze[N][N], int sol[N][N]) {
    for (int i = 0; i < N; i++) {
        for (int j = 0; j < N; j++) {
            if (sol[i][j] == 1)
                printf(" * "); // indicates the path
            else
                printf(" . "); // indicates the wall
        }
        printf("\n");
    }
}

// Recursive utility function to solve the Maze
int solveMazeUtil(int maze[N][N], int x, int y, int sol[N][N]) {
    if (x == N-1 && y == N-1) { // Reached the end
        sol[x][y] = 1;
        return 1;
    }

    if (isSafe(maze, x, y)) {
        sol[x][y] = 1; // Mark as part of solution

        // Move in x direction
        if (solveMazeUtil(maze, x + 1, y, sol))
            return 1;

        // Move in y direction
        if (solveMazeUtil(maze, x, y + 1, sol))
            return 1;

        // Backtracking
        sol[x][y] = 0;
        return 0;
    }
    return 0;
}

// Main function to solve the maze
int solveMaze(int maze[N][N]) {
    int sol[N][N] = { { 0, 0, 0, 0, 0 },
                      { 0, 0, 0, 0, 0 },
                      { 0, 0, 0, 0, 0 },
                      { 0, 0, 0, 0, 0 },
                      { 0, 0, 0, 0, 0 } };

    if (solveMazeUtil(maze, 0, 0, sol) == 0) {
        return 0; // No solution found
    }

    printMaze(maze, sol); // Print the solution path
    return 1; // Solution found
}