//Falcon-180B DATASET v1.0 Category: Personal Finance Planner ; Style: beginner-friendly
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_BUDGET_ITEMS 100

typedef struct {
    char name[50];
    double budget;
} BudgetItem;

void addBudgetItem(BudgetItem* budgetItems, int numItems, char* name, double budget) {
    if (numItems >= MAX_BUDGET_ITEMS) {
        printf("Error: Maximum number of budget items reached.\n");
        return;
    }

    strcpy(budgetItems[numItems].name, name);
    budgetItems[numItems].budget = budget;
    numItems++;
}

void displayBudgetItems(BudgetItem* budgetItems, int numItems) {
    printf("Name\tBudget\n");
    for (int i = 0; i < numItems; i++) {
        printf("%s\t%.2f\n", budgetItems[i].name, budgetItems[i].budget);
    }
}

void calculateTotalBudget(BudgetItem* budgetItems, int numItems) {
    double totalBudget = 0.0;

    for (int i = 0; i < numItems; i++) {
        totalBudget += budgetItems[i].budget;
    }

    printf("Total budget: $%.2f\n", totalBudget);
}

int main() {
    BudgetItem budgetItems[MAX_BUDGET_ITEMS];
    int numItems = 0;

    addBudgetItem(budgetItems, numItems, "Groceries", 200.00);
    addBudgetItem(budgetItems, numItems, "Rent", 1000.00);
    addBudgetItem(budgetItems, numItems, "Utilities", 150.00);
    addBudgetItem(budgetItems, numItems, "Entertainment", 50.00);

    displayBudgetItems(budgetItems, numItems);
    calculateTotalBudget(budgetItems, numItems);

    return 0;
}