//MISTRAL-7B DATASET v1.0 Category: Pattern printing ; Style: romantic
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <time.h>

#define HEIGHT 10
#define WIDTH 31

void print_stars(int num) {
    for (int i = 0; i < num; i++)
        printf("*");
    printf("\n");
}

void print_spaces(int num) {
    for (int i = 0; i < num; i++)
        printf(" ");
}

void print_pattern(int row) {
    int left = WIDTH / 2 - (WIDTH / 2) % 2;
    int space_between_stars = WIDTH / (2 * HEIGHT) - 1;

    print_spaces(left);
    print_stars(1);

    for (int i = 1; i < row; i++) {
        print_spaces(left + (i * (space_between_stars + 1)));
        print_stars(2 * i + 1);
        print_spaces(left + (i * (space_between_stars + 1)) + (2 * i + 1));
        print_stars(1);
        print_spaces(WIDTH - left - (i * (space_between_stars + 1)) - (2 * i + 1) - 2);
        print_stars(2 * i + 1);
        print_spaces(left + (i * (space_between_stars + 1)));
        printf("\n");
    }

    print_spaces(left);
    print_stars(1);
}

int main() {
    srand(time(NULL));

    int random_number = rand() % HEIGHT;

    printf("Once upon a time,\n");
    printf("In a land of love,\n");
    printf("There lived a she,\n");
    printf("And he, a humble knight.\n");
    printf("\n");
    print_pattern(random_number + 1);
    printf("\n");
    printf("He approached her,\n");
    printf("With a rose in his hand,\n");
    printf("And whispered in her ear,\n");
    printf("\"Will you be my lady love?\"\n");
    printf("\n");
    print_pattern(random_number);
    printf("\n");

    return 0;
}