//GPT-4o-mini DATASET v1.0 Category: System boot optimizer ; Style: satisfied
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_SERVICES 50
#define SERVICE_NAME_LEN 30

typedef struct {
    char name[SERVICE_NAME_LEN];
    int isEnabled;
    int importance;  // Rate from 1 to 10 where 10 is critical
} Service;

void displayServices(Service services[], int count) {
    printf("\nCurrent Services:\n");
    printf("-----------------------------------------------------\n");
    printf("| %-20s | %-8s | %-10s |\n", "Service Name", "Enabled", "Importance");
    printf("-----------------------------------------------------\n");
    
    for (int i = 0; i < count; i++) {
        printf("| %-20s | %-8s | %-10d |\n", services[i].name, 
               services[i].isEnabled ? "Yes" : "No", 
               services[i].importance);
    }
    printf("-----------------------------------------------------\n");
}

void recommendOptimizations(Service services[], int count) {
    printf("\nOptimization Recommendations:\n");
    for (int i = 0; i < count; i++) {
        if (services[i].isEnabled && services[i].importance < 5) {
            printf("Consider disabling the service: %s (Importance: %d)\n", 
                   services[i].name, services[i].importance);
        }
    }
}

void simulateLoadServices(Service services[], int *count) {
    // Simulate loading services (static example)
    strcpy(services[0].name, "NetworkManager");
    services[0].isEnabled = 1;
    services[0].importance = 9;

    strcpy(services[1].name, "cupsd");
    services[1].isEnabled = 1;
    services[1].importance = 3;

    strcpy(services[2].name, "crond");
    services[2].isEnabled = 1;
    services[2].importance = 8;

    strcpy(services[3].name, "bluetooth");
    services[3].isEnabled = 1;
    services[3].importance = 4;

    strcpy(services[4].name, "gdm");
    services[4].isEnabled = 1;
    services[4].importance = 6;

    *count = 5;  // Total services loaded
}

void displayWelcomeMessage() {
    printf("=================================\n");
    printf("  System Boot Optimizer v1.0\n");
    printf("=================================\n");
    printf("This program will evaluate your running services and provide optimization suggestions.\n");
}

int main() {
    Service services[MAX_SERVICES];
    int count = 0;

    displayWelcomeMessage();
    simulateLoadServices(services, &count);
    displayServices(services, count);
    recommendOptimizations(services, count);

    return 0;
}