//GEMINI-pro DATASET v1.0 Category: Warehouse Management System ; Style: Claude Shannon
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_ITEMS 100
#define MAX_NAME_LENGTH 20

typedef struct item {
  char name[MAX_NAME_LENGTH];
  int quantity;
  float price;
} item;

item warehouse[MAX_ITEMS];
int num_items = 0;

void add_item(char *name, int quantity, float price) {
  if (num_items == MAX_ITEMS) {
    printf("Error: Warehouse is full.\n");
    return;
  }
  strcpy(warehouse[num_items].name, name);
  warehouse[num_items].quantity = quantity;
  warehouse[num_items].price = price;
  num_items++;
}

void remove_item(char *name) {
  int i;
  for (i = 0; i < num_items; i++) {
    if (strcmp(warehouse[i].name, name) == 0) {
      break;
    }
  }
  if (i == num_items) {
    printf("Error: Item not found.\n");
    return;
  }
  for (; i < num_items - 1; i++) {
    warehouse[i] = warehouse[i + 1];
  }
  num_items--;
}

void print_inventory() {
  int i;
  for (i = 0; i < num_items; i++) {
    printf("%s %d %.2f\n", warehouse[i].name, warehouse[i].quantity, warehouse[i].price);
  }
}

int main() {
  add_item("Apple", 10, 0.50);
  add_item("Banana", 20, 0.75);
  add_item("Orange", 30, 1.00);
  print_inventory();
  remove_item("Apple");
  print_inventory();
  return 0;
}