//Gemma-7B DATASET v1.0 Category: Terminal Based Game ; Style: decentralized
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_BUFFER_SIZE 1024

typedef struct GameContext {
  char board[9][9];
  int turn;
  int winner;
} GameContext;

GameContext gContext;

void initGame() {
  gContext.turn = 0;
  gContext.winner = 0;
  for (int r = 0; r < 9; r++) {
    for (int c = 0; c < 9; c++) {
      gContext.board[r][c] = ' ';
    }
  }
}

void makeMove(int row, int col) {
  if (gContext.board[row][col] != ' ') {
    return;
  }
  gContext.board[row][col] = gContext.turn == 0 ? 'X' : 'O';
  gContext.turn++;
}

void checkWin() {
  for (int r = 0; r < 9; r++) {
    if (gContext.board[r][0] == gContext.board[r][1] && gContext.board[r][0] == gContext.board[r][2] && gContext.board[r][0] != ' ') {
      gContext.winner = gContext.board[r][0] - 'X';
      return;
    }
  }
  for (int c = 0; c < 9; c++) {
    if (gContext.board[0][c] == gContext.board[1][c] && gContext.board[0][c] == gContext.board[2][c] && gContext.board[0][c] != ' ') {
      gContext.winner = gContext.board[0][c] - 'X';
      return;
    }
  }
  if (gContext.board[0][0] == gContext.board[1][1] && gContext.board[0][0] == gContext.board[2][2] && gContext.board[0][0] != ' ') {
    gContext.winner = gContext.board[0][0] - 'X';
    return;
  }
  gContext.winner = -1;
}

int main() {
  initGame();
  makeMove(1, 1);
  makeMove(2, 2);
  makeMove(0, 0);
  checkWin();
  printf("The winner is: %c\n", gContext.winner);
  return 0;
}