//GEMINI-pro DATASET v1.0 Category: Geometric algorithms ; Style: Sherlock Holmes
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

/*
 * The following function takes an array of points and returns the point that is farthest from the origin.
 *
 * Args:
 *     points: An array of points.
 *     num_points: The number of points in the array.
 *
 * Returns:
 *     The point that is farthest from the origin.
 */
struct point {
    double x;
    double y;
};

struct point farthest_from_origin(struct point *points, int num_points) {
    struct point farthest_point;
    double max_distance = 0.0;

    for (int i = 0; i < num_points; i++) {
        double distance = sqrt(points[i].x * points[i].x + points[i].y * points[i].y);
        if (distance > max_distance) {
            max_distance = distance;
            farthest_point = points[i];
        }
    }

    return farthest_point;
}

int main() {
    // Create an array of points.
    struct point points[] = {
        {0.0, 0.0},
        {1.0, 0.0},
        {0.0, 1.0},
        {-1.0, 0.0},
        {0.0, -1.0}
    };

    // Find the point that is farthest from the origin.
    struct point farthest_point = farthest_from_origin(points, 5);

    // Print the point that is farthest from the origin.
    printf("The point that is farthest from the origin is (%f, %f).\n", farthest_point.x, farthest_point.y);

    return 0;
}