//Gemma-7B DATASET v1.0 Category: Chess engine ; Style: Claude Shannon
#include <stdlib.h>
#include <time.h>

#define MOVE_DIR_UP 0
#define MOVE_DIR_DOWN 1
#define MOVE_DIR_RIGHT 2
#define MOVE_DIR_LEFT 3

#define MAX_DEPTH 5

typedef struct Move {
    int x, y, dir, piece;
} Move;

Move generate_move() {
    Move move;
    move.x = rand() % 8;
    move.y = rand() % 8;
    move.dir = rand() % 4;
    move.piece = rand() % 6;
    return move;
}

int evaluate_move(Move move) {
    int evaluation = 0;
    switch (move.piece) {
        case 0:
            evaluation += 10;
            break;
        case 1:
            evaluation += 5;
            break;
        case 2:
            evaluation += 3;
            break;
        case 3:
            evaluation += 2;
            break;
        case 4:
            evaluation += 1;
            break;
        case 5:
            evaluation += 0;
            break;
    }
    switch (move.dir) {
        case MOVE_DIR_UP:
            evaluation += 2;
            break;
        case MOVE_DIR_DOWN:
            evaluation -= 2;
            break;
        case MOVE_DIR_RIGHT:
            evaluation += 1;
            break;
        case MOVE_DIR_LEFT:
            evaluation -= 1;
            break;
    }
    return evaluation;
}

int main() {
    srand(time(NULL));
    Move move;
    for (int i = 0; i < MAX_DEPTH; i++) {
        move = generate_move();
        int evaluation = evaluate_move(move);
        printf("Move: x=%d, y=%d, dir=%d, piece=%d, evaluation=%d\n", move.x, move.y, move.dir, move.piece, evaluation);
    }
    return 0;
}